// ProcDlg.cpp : implementation file
//

#include "stdafx.h"
#include "sdobjects_demo.h"
#include "ProcDlg.h"
#include "ProcResultDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CProcDlg dialog


CProcDlg::CProcDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CProcDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CProcDlg)
	_addend1 = 0;
	_addend2 = 0;
	_sum = 0;
	_percent = 0;
	_output_line = _T("");
	//}}AFX_DATA_INIT

	_does_procedure_exist=FALSE;
}


void CProcDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CProcDlg)
	DDX_Text(pDX, IDC_ADDEND1, _addend1);
	DDX_Text(pDX, IDC_ADDEND2, _addend2);
	DDX_Text(pDX, IDC_SUM, _sum);
	DDX_Text(pDX, IDC_PERCENT, _percent);
	DDX_Text(pDX, IDC_OUTPUT, _output_line);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CProcDlg, CDialog)
	//{{AFX_MSG_MAP(CProcDlg)
	ON_BN_CLICKED(IDC_EXECUTE1, OnExecute1)
	ON_BN_CLICKED(IDC_EXECUTE2, OnExecute2)
	ON_BN_CLICKED(IDC_CREATE, OnCreate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProcDlg message handlers

void CProcDlg::OnExecute1() 
{
	// make sure we created the procedure
	if(! _does_procedure_exist )
	{
		AfxMessageBox("Click the create button first, then re-execute");
		return;
	}
		
	// get screen variables
	UpdateData(TRUE);
	
	// here we create our sdo_procedure object
	// and pass in an sdo_connection pointer
	// and the name of the procedure to
	// execute
	sdo_procedure procedure(&g_conn,"sdobject_test_proc");

	// using << and >> to denote input or output
	// variables, we bind our procedure parameters

	procedure<<_addend1<<_addend2>>_sum>>_output_line;

	// now we execute the procedure
	procedure.execute();

	// now put the variables on the screen
	UpdateData(FALSE);

	// again, if you've ever coded all this stuff in
	// the native ODBC API, you're probably so happy
	// right now you're considering being nice to your
	// mother in law.
}

void CProcDlg::OnExecute2() 
{
	// here, were going to execute a procedure
	// that comes with the MS SQL Server 6.5
	// sample Pubs database. this will demonstrate
	// how easy it is to retrieve a rowset on the
	// connection when it is created by a procedure.
	// note that some RDBMS's, namely Oracle, cannot
	// produce a rowset through a stored procedure.
	
	// get screen variables
	UpdateData(TRUE);

	// create the sdo_procedure object
	// byroyalty is the proc name
	sdo_procedure procedure(&g_conn,"byroyalty");

	// using the << operator, we bind our 
	// procedure parameters
	procedure<<_percent;

	// now we can execute the procedure. if successful,
	// we create a dialog to scroll through the rowset
	if(procedure.execute())
	{
		// we'll pass a pointer to
		// the sdo_procedure object
		CProcResultDlg dlg(&procedure);
		dlg.DoModal();
	}
}

void CProcDlg::OnCreate() 
{
	// here we'll create and use an sdo_command object
	// which is used to issue commands and non data
	// related communications to the database

	sdo_command command(&g_conn);

	// now we can set the sdo_command 
	// object command like so...
	// this is MS SQL Server 6.5 T-SQL

	command="if exists (select * from sysobjects where\
		id = object_id('dbo.sdobject_test_proc') and\
		sysstat & 0xf = 4) drop procedure dbo.sdobject_test_proc";

	// now we'll execute that portion of the batch
	command.execute();

	// now we'll create the procedure with the following
	command="CREATE PROCEDURE sdobject_test_proc\
		@addend1 integer ,@addend2 integer,\
		@sum integer OUTPUT ,@string_out char(50) OUTPUT\
		AS SELECT @sum=@addend1+@addend2 SELECT @string_out\
		='As of ' + CONVERT(char(10),getdate(),101) + ',  '\
		+ CONVERT(char(3),@addend1) + ' + ' + CONVERT(char(3),\
		@addend2) + ' =  ' + CONVERT(char(4),@sum)";

	// now execute that part of the batch. note that
	// all sdo_object functions return either a boolean
	// true or false
	if(command.execute())
	{
		AfxMessageBox("Procedure created successfully");
		_does_procedure_exist=TRUE;
	}
}

BOOL CProcDlg::DestroyWindow() 
{
	// we'll drop the procedure from the
	// database when this dialog is destroyed

	sdo_command command(&g_conn);

	command="if exists (select * from sysobjects where\
		id = object_id('dbo.sdobject_test_proc') and\
		sysstat & 0xf = 4) drop procedure dbo.sdobject_test_proc";

	// execute and it's gone!
	command.execute();

	return CDialog::DestroyWindow();
}
